/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.client.screen;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.config.adapter.TypeAdapters;
import mod.azure.azurelib.common.config.client.DisplayAdapter;
import mod.azure.azurelib.common.config.client.DisplayAdapterManager;
import mod.azure.azurelib.common.config.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.common.config.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.common.config.validate.NotificationSeverity;
import mod.azure.azurelib.common.config.value.ArrayValue;
import mod.azure.azurelib.common.config.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ArrayConfigScreen<V, C extends ConfigValue<V>>
extends AbstractConfigScreen {
    public static final class_2561 ADD_ELEMENT = class_2561.method_43471((String)"text.azurelib.value.add_element");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V> removeHandler;

    public ArrayConfigScreen(String ownerIdentifier, String configId, C array, class_437 previous) {
        super((class_2561)class_2561.method_43471((String)String.format("config.%s.option.%s", configId, ownerIdentifier)), previous, configId);
        this.array = array;
        this.fixedSize = ((ArrayValue)array).isFixedSize();
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter<V>(componentType, parent, callback, index);
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V> handler) {
        this.removeHandler = handler;
    }

    protected void method_25426() {
        int viewportMin = 35;
        int viewportHeight = this.field_22790 - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.sizeSupplier.get());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        Class<?> compType = ((ConfigValue)this.array).get().getClass().getComponentType();
        DisplayAdapter adapter = DisplayAdapterManager.forType(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processFieldData(owner);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.method_37063((class_364)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.field_22789 - 60, 20, dummy, this.configId));
            widget.setDescriptionRenderer((graphics, widget1, severity, text) -> this.renderEntryDescription(graphics, widget1, severity, text));
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(dummy, owner, widget);
                this.initializeGuiValue(dummy, widget);
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)compType.getSimpleName(), (Object)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"x"), btn -> {
                this.removeHandler.removeElementAt(elementIndex, (index, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, index);
                    System.arraycopy(src, index + 1, dest, index, this.sizeSupplier.get() - 1 - index);
                    return dest;
                });
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }).method_46433(this.field_22789 - 28, widget.method_46427()).method_46437(20, 20).method_46431());
        }
        this.addFooter();
    }

    private void renderEntryDescription(class_332 graphics, class_339 widget, NotificationSeverity severity, List<class_5481> text) {
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, graphics, text, widget.method_46426() + 5, widget.method_46427() + widget.method_25364() + 10);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        int n = (this.field_22789 - titleWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        graphics.method_27535(this.field_22793, this.field_22785, n, (35 - 9) / 2, 0xFFFFFF);
        graphics.method_25294(0, 0, this.field_22789, 35, -1728053248);
        graphics.method_25294(0, this.field_22790 - 30, this.field_22789, this.field_22790, -1728053248);
        graphics.method_25294(0, 35, this.field_22789, this.field_22790 - 30, 0x55000000);
        ArrayConfigScreen.renderScrollbar(graphics, this.field_22789 - 5, 35, 5, this.field_22790 - 30 - 35, this.index, this.sizeSupplier.get(), this.pageSize);
        this.field_33816.forEach(renderable -> renderable.method_25394(graphics, mouseX, mouseY, partialTicks));
    }

    @Override
    protected void addFooter() {
        super.addFooter();
        if (!this.fixedSize) {
            int centerY = this.field_22790 - 30 + 5;
            this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_ELEMENT, btn -> {
                this.addHandler.insertElement();
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }).method_46433(this.field_22789 - 100, centerY).method_46437(80, 20).method_46431());
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount, double g) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.sizeSupplier.get()) {
            this.index = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapters.forType(type);
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }
}

